(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     88323,       2768]
NotebookOptionsPosition[     82097,       2602]
NotebookOutlinePosition[     82826,       2625]
CellTagsIndexPosition[     82783,       2622]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Total Aberrations", "Title"],

Cell["\<\
TotalAberrations is an auxiliary function used by all other Geometric Optic \
packages to calculate aberrations.\
\>", "Text"],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Input variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["rad",
           FontWeight->Bold], Cell["list of the radii of the surfaces"]},
         {Cell["thick",
           FontWeight->Bold], Cell["\<\
list of the distances between the surfaces along the optical axis\
\>"]},
         {Cell["ind",
           FontWeight->Bold], Cell["list of the refractive indices"]},
         {Cell["costasf",
           FontWeight->Bold], 
          TagBox[GridBox[{
             {"\<\"list of the constants which characterize the nature of any \
surface\"\>"},
             {"\<\"(0 for a sphere, K for a conic, {a4, as} for an aspheric \
surface)\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"]},
         {Cell["stoprad",
           FontWeight->Bold], Cell["radius of the aperture stop"]},
         {Cell["nstop",
           FontWeight->Bold], Cell["number of the surfaces before the stop"]},
         {Cell["dis",
           FontWeight->Bold], 
          TagBox[GridBox[{
             {"\<\"if nstop = 0, is the (negative) distance of the aperture \
stop from the first surface after it\"\>"},
             {"\<\"if nstop > 0,  is the distance between the last surface \
before the aperture stop and the aperture stop\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"]},
         {Cell["dobject",
           FontWeight->Bold], Cell[
          "distance of the object from the first surface"]},
         {Cell["hobject",
           FontWeight->Bold], Cell["\<\
height of the object (only if the object is at a finite distance)\
\>"]},
         {Cell["angle",
           FontWeight->Bold], Cell[
          "view angle in degrees (if the object is at infinity)"]},
         {Cell["waves",
           FontWeight->Bold], Cell[
          "the wavelengths of the chosen refractive indices"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Optional arguments\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["OutputType", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], "\[SpanFromLeft]"},
         {"\[SpanFromAbove]", Cell["Report"], Cell["\<\
generates a report as a new notebook, that can be saved in many formats, for \
instance PDF\
\>"]},
         {"\[SpanFromAbove]", Cell["Print"], Cell["\<\
prints results in the current position of the evaluating notebook\
\>"]},
         {"\[SpanFromAbove]", Cell["Basic"], Cell["\<\
returns the list of pairs, with the short description of the output and the \
corresponding value\
\>"]},
         {"\[SpanFromAbove]", Cell["Values"], Cell[
          "returns only the list of output values, no descriptions"]},
         {Cell["OutputLevel", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], Cell[""]},
         {"\[SpanFromAbove]", Cell["Full"], Cell[
          "gives both input parameters and output values"]},
         {"\[SpanFromAbove]", Cell["Minimal"], Cell[
          "gives only output values"]},
         {"\[SpanFromAbove]", Cell["Coefficients"], Cell[
          "gives only aberration coefficients"]},
         {"\[SpanFromAbove]", Cell["None"], Cell["doesn't show any result"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Output variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["GOn",
           FontWeight->Bold], Cell["Number of surface"]},
         {Cell["GOren",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Radius of the entrance pupil for \"",SubscriptBox[
            "\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOwen",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Distance of the exit pupil from the last surface for \"",
            SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOrexit",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Radius of the exit pupil for \"",SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOdistancefp",
           FontWeight->Bold], Cell[
          "Distance of the first principal plane from the first surface"]},
         {Cell["GOdistancesp",
           FontWeight->Bold], Cell[
          "Distance of the second principal plane from the last surface"]},
         {Cell["GOdistancegauss",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Gaussian distance of the images from the surface for \"",
            SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOfocalLength",
           FontWeight->Bold], Cell["Focal length"]},
         {Cell["GOimageHeight",
           FontWeight->Bold], Cell["Image height"]},
         {Cell["GOaberration",
           FontWeight->Bold], Cell["Third-order spherical aberration "]},
         {Cell["GOcoma",
           FontWeight->Bold], Cell["Third-order coma"]},
         {Cell["GOastigmatism",
           FontWeight->Bold], Cell["Third-order astigmatism"]},
         {Cell["GOcurvature",
           FontWeight->Bold], Cell["Third-order total curvature"]},
         {Cell["GOSeidelCurvature",
           FontWeight->Bold], Cell["Third-order curvature coefficient"]},
         {Cell["GOPetzvalRadius",
           FontWeight->Bold], Cell["Petzval radius"]},
         {Cell["GOdistortion",
           FontWeight->Bold], Cell["Third-order distortion"]},
         {Cell["GOSphericalCoefficient",
           FontWeight->Bold], Cell["Spherical Coefficient"]},
         {Cell["GOComaCoefficient",
           FontWeight->Bold], Cell["Coma Coefficient"]},
         {Cell["GOAstigmatismCoefficient",
           FontWeight->Bold], Cell["Astigmatism Coefficient"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["TotalAberrations Examples", "Title"],

Cell["\<\
TotalAberrations is used as auxiliary function from all other packages and \
for that normally it doesn\[CloseCurlyQuote]t print out any result. Indeed, \
it sets the value of some variables which are used by other packages. 
When you run TotalAberration directly, you would need to set the optional \
argument OutputType so to show returned output.
If you want to set the same type of output for all evaluations, set the \
option before to start.\
\>", "Text"],

Cell["\<\
Example:  producing a report with outputs as separated notebook \
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rad", "=", 
   RowBox[{"{", "40", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", "0", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ind", "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1.518722"}], "}"}], "}"}]}], ";"}], 
  RowBox[{"(*", "BK7", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"stoprad", "=", "5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", "0", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"nstop", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dis", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dobject", "=", 
   RowBox[{"-", "Infinity"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"hobject", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"angle", "=", "3"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", "0.54607", "}"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "angle", ",", 
   "waves", ",", " ", 
   RowBox[{"OutputLevel", "\[Rule]", "\"\<Minimal\>\""}], ",", " ", 
   RowBox[{"OutputType", "\[Rule]", "\"\<Report\>\""}]}], "]"}]], "Input"],

Cell["returning a list of output values", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "angle", ",", 
   "waves", ",", " ", 
   RowBox[{"OutputLevel", "\[Rule]", "\"\<Minimal\>\""}], ",", " ", 
   RowBox[{"OutputType", "\[Rule]", "\"\<Basic\>\""}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Output values\"\>", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"GOwe\"\>", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"GOren\"\>", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"GOwen\"\>", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"GOrexit\"\>", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"GOdistancefp\"\>", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"GOdistancesp\"\>", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"GOdistancegauss\"\>", ",", 
       RowBox[{"{", 
        RowBox[{"{", "117.11259595698662`", "}"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"GOfocalLength\"\>", ",", 
       RowBox[{"{", "117.11259595698662`", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"GOimageHeight\"\>", ",", 
       RowBox[{"{", 
        RowBox[{"{", "4.037606082628453`", "}"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"GOaberration\"\>", ",", 
       RowBox[{"{", 
        RowBox[{"-", "0.01693571226350473`"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"GOcoma\"\>", ",", 
       RowBox[{"{", 
        RowBox[{"-", "0.007094014564044935`"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"GOastigmatism\"\>", ",", 
       RowBox[{"{", 
        RowBox[{"-", "0.002971533871848342`"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"GOcurvature\"\>", ",", 
       RowBox[{"-", "0.00451293386492126`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"GOPetzvalRadius\"\>", ",", 
       RowBox[{"-", "77.1125959569866`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"GOdistortion\"\>", ",", 
       RowBox[{"-", "0.0031350865143820266`"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell["print a table with outputs", "Text"],

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "angle", ",", 
   "waves", ",", " ", 
   RowBox[{"OutputLevel", "\[Rule]", "\"\<Minimal\>\""}], ",", " ", 
   RowBox[{"OutputType", "\[Rule]", "\"\<Print\>\""}]}], "]"}]], "Input"],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Total Aberrations\"\>", "Title",
       StripOnInput->False]},
     {
      StyleBox["\<\"Thu 1 Sep 2016 08:21:31\"\>", "Date",
       StripOnInput->False]},
     {
      StyleBox["\<\"TotalAberrations\"\>", "Function",
       StripOnInput->False]},
     {
      InterpretationBox[
       StyleBox[
        GraphicsBox[{},
         BaselinePosition->Baseline,
         ImageSize->{10, 0}],
        CacheGraphics->False],
       Spacer[10]]},
     {
      StyleBox["\<\"Output values\"\>", "OutputValueTop",
       StripOnInput->False]},
     {
      TagBox[GridBox[{
         {
          
          TemplateBox[{
           "\"Distance of entrance pupil from the first surface for \"",
            TemplateBox[{
              SubscriptBox["\"\[Lambda]\"", "1"], "\" = \"", "0.54607`"}, 
             "RowDefault"]},
           "RowDefault"], 
          SubscriptBox["\<\"w\"\>", "\<\"e\"\>"], "0"},
         {
          TemplateBox[{"\"Radius of the entrance pupil for \"",TemplateBox[{
              SubscriptBox["\"\[Lambda]\"", "1"], "\" = \"", "0.54607`"}, 
             "RowDefault"]},
           "RowDefault"], 
          SubscriptBox["\<\"r\"\>", "\<\"en\"\>"], "5"},
         {
          
          TemplateBox[{
           "\"Distance of the exit pupil from the last surface for \"",
            TemplateBox[{
              SubscriptBox["\"\[Lambda]\"", "1"], "\" = \"", "0.54607`"}, 
             "RowDefault"]},
           "RowDefault"], 
          SubscriptBox["\<\"w\"\>", "\<\"en\"\>"], "0"},
         {
          TemplateBox[{"\"Radius of the exit pupil for \"",TemplateBox[{
              SubscriptBox["\"\[Lambda]\"", "1"], "\" = \"", "0.54607`"}, 
             "RowDefault"]},
           "RowDefault"], 
          SubscriptBox["\<\"r\"\>", "\<\"ex\"\>"], "5"},
         {"\<\"Distance of the first principal plane from the first surface\"\
\>", "\<\"\"\>", "0.`"},
         {"\<\"Distance of the second principal plane from the last surface\"\
\>", "\<\"\"\>", "0.`"},
         {
          
          TemplateBox[{
           "\"Gaussian distance of the images from the surface for \"",
            TemplateBox[{
              SubscriptBox["\"\[Lambda]\"", "1"], "\" = \"", "0.54607`"}, 
             "RowDefault"]},
           "RowDefault"], "\<\"\"\>", 
          TagBox[GridBox[{
             {"117.11259595698662`"}
            },
            BaseStyle->"Pane",
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Right}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
           "Column"]},
         {"\<\"Focal length\"\>", "\<\"\"\>", "117.11259595698662`"},
         {"\<\"Image height\"\>", "\<\"\"\>", "4.037606082628453`"},
         {"\<\"Third-order spherical aberration\"\>", 
          TagBox[GridBox[{
             {"0.54607`"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"], 
          TagBox[GridBox[{
             {
              RowBox[{"-", "0.01693571226350473`"}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"]},
         {"\<\"Third-order coma\"\>", 
          TagBox[GridBox[{
             {"0.54607`"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"], 
          TagBox[GridBox[{
             {
              RowBox[{"-", "0.007094014564044935`"}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"]},
         {"\<\"Third-order astigmatism\"\>", 
          TagBox[GridBox[{
             {"0.54607`"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"], 
          TagBox[GridBox[{
             {
              RowBox[{"-", "0.002971533871848342`"}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"]},
         {"\<\"Third-order curvature\"\>", "\<\"\"\>", 
          RowBox[{"-", "0.00451293386492126`"}]},
         {"\<\"Petzval radius\"\>", "\<\"\"\>", 
          RowBox[{"-", "77.1125959569866`"}]},
         {"\<\"Third-order distortion\"\>", "\<\"\"\>", 
          RowBox[{"-", "0.0031350865143820266`"}]},
         {"\<\"Spherical coefficient\"\>", "\<\"\"\>", 
          RowBox[{"-", "4.3924632683748485`*^-7"}]},
         {"\<\"Coma coefficient\"\>", "\<\"\"\>", 
          RowBox[{"-", "0.00007027941229399758`"}]},
         {"\<\"Astigmatism coefficient\"\>", "\<\"\"\>", 
          RowBox[{"-", "0.0028111764917599026`"}]}
        },
        AutoDelete->False,
        BaseStyle->{"OutputValueBottom"},
        FrameStyle->GrayLevel[0.85],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1}}}],
       "Grid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Left}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.9],
  BaseStyle->"InputParameterTop"]], "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell["\<\
Once you decided your preferred output type and level, you may also set the \
two options using SetOptions so to not replicate them at each call of \
TotalAberrations\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{"TotalAberrations", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"OutputLevel", "\[Rule]", "\"\<Minimal\>\""}], ",", " ", 
     RowBox[{"OutputType", "\[Rule]", "\"\<Print\>\""}]}], "}"}]}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"OutputType", "\[Rule]", "\<\"Print\"\>"}], ",", 
   RowBox[{"OutputLevel", "\[Rule]", "\<\"Minimal\"\>"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["Dioptric with adjacent stop and object at infinity", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rad", "=", 
   RowBox[{"{", "40", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", "0", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ind", "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1.518722"}], "}"}], "}"}]}], ";"}], 
  RowBox[{"(*", "BK7", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"stoprad", "=", "5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", "0", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"nstop", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dis", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dobject", "=", 
   RowBox[{"-", "Infinity"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"hobject", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"angle", "=", "3"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", "0.54607", "}"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "angle", ",", 
   "waves"}], "]"}]], "Input"],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Total Aberrations\"\>", "Title",
       StripOnInput->False]},
     {
      StyleBox["\<\"Thu 1 Sep 2016 08:22:52\"\>", "Date",
       StripOnInput->False]},
     {
      StyleBox["\<\"TotalAberrations\"\>", "Function",
       StripOnInput->False]},
     {
      InterpretationBox[
       StyleBox[
        GraphicsBox[{},
         BaselinePosition->Baseline,
         ImageSize->{10, 0}],
        CacheGraphics->False],
       Spacer[10]]},
     {
      StyleBox["\<\"Output values\"\>", "OutputValueTop",
       StripOnInput->False]},
     {
      TagBox[GridBox[{
         {
          
          TemplateBox[{
           "\"Distance of entrance pupil from the first surface for \"",
            TemplateBox[{
              SubscriptBox["\"\[Lambda]\"", "1"], "\" = \"", "0.54607`"}, 
             "RowDefault"]},
           "RowDefault"], 
          SubscriptBox["\<\"w\"\>", "\<\"e\"\>"], "0"},
         {
          TemplateBox[{"\"Radius of the entrance pupil for \"",TemplateBox[{
              SubscriptBox["\"\[Lambda]\"", "1"], "\" = \"", "0.54607`"}, 
             "RowDefault"]},
           "RowDefault"], 
          SubscriptBox["\<\"r\"\>", "\<\"en\"\>"], "5"},
         {
          
          TemplateBox[{
           "\"Distance of the exit pupil from the last surface for \"",
            TemplateBox[{
              SubscriptBox["\"\[Lambda]\"", "1"], "\" = \"", "0.54607`"}, 
             "RowDefault"]},
           "RowDefault"], 
          SubscriptBox["\<\"w\"\>", "\<\"en\"\>"], "0"},
         {
          TemplateBox[{"\"Radius of the exit pupil for \"",TemplateBox[{
              SubscriptBox["\"\[Lambda]\"", "1"], "\" = \"", "0.54607`"}, 
             "RowDefault"]},
           "RowDefault"], 
          SubscriptBox["\<\"r\"\>", "\<\"ex\"\>"], "5"},
         {"\<\"Distance of the first principal plane from the first surface\"\
\>", "\<\"\"\>", "0.`"},
         {"\<\"Distance of the second principal plane from the last surface\"\
\>", "\<\"\"\>", "0.`"},
         {
          
          TemplateBox[{
           "\"Gaussian distance of the images from the surface for \"",
            TemplateBox[{
              SubscriptBox["\"\[Lambda]\"", "1"], "\" = \"", "0.54607`"}, 
             "RowDefault"]},
           "RowDefault"], "\<\"\"\>", 
          TagBox[GridBox[{
             {"117.11259595698662`"}
            },
            BaseStyle->"Pane",
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Right}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
           "Column"]},
         {"\<\"Focal length\"\>", "\<\"\"\>", "117.11259595698662`"},
         {"\<\"Image height\"\>", "\<\"\"\>", "4.037606082628453`"},
         {"\<\"Third-order spherical aberration\"\>", 
          TagBox[GridBox[{
             {"0.54607`"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"], 
          TagBox[GridBox[{
             {
              RowBox[{"-", "0.01693571226350473`"}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"]},
         {"\<\"Third-order coma\"\>", 
          TagBox[GridBox[{
             {"0.54607`"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"], 
          TagBox[GridBox[{
             {
              RowBox[{"-", "0.007094014564044935`"}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"]},
         {"\<\"Third-order astigmatism\"\>", 
          TagBox[GridBox[{
             {"0.54607`"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"], 
          TagBox[GridBox[{
             {
              RowBox[{"-", "0.002971533871848342`"}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"]},
         {"\<\"Third-order curvature\"\>", "\<\"\"\>", 
          RowBox[{"-", "0.00451293386492126`"}]},
         {"\<\"Petzval radius\"\>", "\<\"\"\>", 
          RowBox[{"-", "77.1125959569866`"}]},
         {"\<\"Third-order distortion\"\>", "\<\"\"\>", 
          RowBox[{"-", "0.0031350865143820266`"}]},
         {"\<\"Spherical coefficient\"\>", "\<\"\"\>", 
          RowBox[{"-", "4.3924632683748485`*^-7"}]},
         {"\<\"Coma coefficient\"\>", "\<\"\"\>", 
          RowBox[{"-", "0.00007027941229399758`"}]},
         {"\<\"Astigmatism coefficient\"\>", "\<\"\"\>", 
          RowBox[{"-", "0.0028111764917599026`"}]}
        },
        AutoDelete->False,
        BaseStyle->{"OutputValueBottom"},
        FrameStyle->GrayLevel[0.85],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1}}}],
       "Grid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Left}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.9],
  BaseStyle->"InputParameterTop"]], "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell["Dioptric with anterior stop and object at infinity ", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rad", "=", 
   RowBox[{"{", "40", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", "0", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ind", "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1.518722"}], "}"}], "}"}]}], ";"}], 
  RowBox[{"(*", "BK7", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"stoprad", "=", "5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", "0", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"nstop", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dis", "=", 
   RowBox[{"-", "20"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dobject", "=", 
   RowBox[{"-", 
    RowBox[{"10", "^", 
     RowBox[{"(", "20", ")"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"hobject", "=", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"10", "^", 
      RowBox[{"(", "20", ")"}]}]}], 
    RowBox[{"(", 
     RowBox[{"\[Pi]", "/", "180"}], ")"}], "3"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"angle", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", "0.54607", "}"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "angle", ",", 
   "waves"}], "]"}]], "Input"],

Cell["Output values as printed table", "Text"],

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{"TotalAberrations", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"OutputLevel", "\[Rule]", "\"\<Minimal\>\""}], ",", " ", 
     RowBox[{"OutputType", "\[Rule]", "\"\<Print\>\""}]}], "}"}]}], 
  "]"}]], "Input"],

Cell["Dioptric with stop and object at finite distance ", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rad", "=", 
   RowBox[{"{", "40", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", "0", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ind", "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1.518722"}], "}"}], "}"}]}], ";"}], 
  RowBox[{"(*", "BK7", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"stoprad", "=", "5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", "0", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"nstop", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dis", "=", 
   RowBox[{"-", "5"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dobject", "=", 
   RowBox[{"-", "130"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"hobject", "=", "5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", "0.54607", "}"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "angle", ",", 
   "waves"}], "]"}]], "Input"],

Cell["Dioptric with posterior stop and object at finite distance", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "angle", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rad", "=", 
   RowBox[{"{", "40", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", "0", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1.518722"}], "}"}], "}"}]}], ";", 
  RowBox[{"(*", "BK7", "*)"}], "\n", 
  RowBox[{"stoprad", "=", "5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", "0", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"nstop", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dis", "=", "10"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dobject", "=", 
   RowBox[{"-", "120"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"hobject", "=", "5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"angle", "=", "\[Theta]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", "0.54607", "}"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "angle", ",", 
   "waves"}], "]"}]], "Input"],

Cell["Dioptric with adjacent stop and object at finite distance", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rad", "=", 
   RowBox[{"{", "40", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ind", "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1.518722"}], "}"}], "}"}]}], ";"}], 
  RowBox[{"(*", "BK7", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"stoprad", "=", "5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", "0", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"nstop", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dis", "=", 
   RowBox[{"-", 
    RowBox[{"10", "^", 
     RowBox[{"(", 
      RowBox[{"-", "3"}], ")"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dobject", "=", 
   RowBox[{"-", "120"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"hobject", "=", "5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", "0.54607", "}"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "angle", ",", 
   "waves"}], "]"}]], "Input"],

Cell["Lens with adjacent aperture stop and object at infinite ", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rad", "=", 
   RowBox[{"{", 
    RowBox[{"50", ",", 
     RowBox[{"-", "50"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", "8", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ind", "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1.518722", ",", "1"}], "}"}], "}"}]}], ";"}], 
  RowBox[{"(*", "BK7", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"stoprad", "=", "10"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"nstop", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dis", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dobject", "=", 
   RowBox[{"-", "Infinity"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"hobject", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"angle", "=", "3"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", "0.54607", "}"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "angle", ",", 
   "waves"}], "]"}]], "Input"],

Cell["\<\
Lens with anterior aperture stop and object at finite distance\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rad", "=", 
   RowBox[{"{", 
    RowBox[{"50", ",", 
     RowBox[{"-", "50"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", "8", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ind", "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1.518722", ",", "1"}], "}"}], "}"}]}], ";"}], 
  RowBox[{"(*", "BK7", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"stoprad", "=", "10"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"nstop", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dis", "=", 
   RowBox[{"-", "6"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dobject", "=", 
   RowBox[{"-", "80"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"hobject", "=", "10"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"angle", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", "0.54607", "}"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "angle", ",", 
   "waves"}], "]"}]], "Input"],

Cell["\<\
Lens with anterior aperture stop and object at finite distance\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rad", "=", 
   RowBox[{"{", 
    RowBox[{"50", ",", 
     RowBox[{"-", "50"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", "8", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ind", "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1.518722", ",", "1"}], "}"}], "}"}]}], ";"}], 
  RowBox[{"(*", "BK7", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"stoprad", "=", "10"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"nstop", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dis", "=", 
   RowBox[{"-", "6"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dobject", "=", 
   RowBox[{"-", "80"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"hobject", "=", "10"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"angle", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", "0.54607", "}"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "angle", ",", 
   "waves"}], "]"}]], "Input"],

Cell["\<\
Lens with posterior aperture stop and object at finite distance\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rad", "=", 
   RowBox[{"{", 
    RowBox[{"70", ",", 
     RowBox[{"-", "70"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", "10", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ind", "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1.518722", ",", "1"}], "}"}], "}"}]}], ";"}], 
  RowBox[{"(*", "BK7", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"stoprad", "=", "10"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"nstop", "=", "2"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dis", "=", "10"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dobject", "=", 
   RowBox[{"-", "120"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"hobject", "=", "10"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"angle", "=", "\[CapitalTheta]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", "0.54607", "}"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "angle", ",", 
   "waves"}], "]"}]], "Input"],

Cell["\<\
Two lenses with the aperture stop inside and object at infinity\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rad", "=", 
   RowBox[{"{", 
    RowBox[{"40", ",", 
     RowBox[{"10", "^", "16"}], ",", 
     RowBox[{"10", "^", "16"}], ",", 
     RowBox[{"-", "40"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", 
    RowBox[{"5", ",", "10", ",", "5"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ind", "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1.518722", ",", "1", ",", "1.518722", ",", "1"}], 
      "}"}], "}"}]}], ";"}], 
  RowBox[{"(*", "BK7", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"stoprad", "=", "10"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"nstop", "=", "2"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dis", "=", "5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dobject", "=", 
   RowBox[{"-", "Infinity"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"hobject", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"angle", "=", "10"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", "0.54607", "}"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "angle", ",", 
   "waves"}], "]"}]], "Input"],

Cell["\<\
Two lenses with the aperture stop inside and object at infinity\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rad", "=", 
   RowBox[{"{", 
    RowBox[{"60", ",", 
     RowBox[{"-", "60"}], ",", 
     RowBox[{"-", "40"}], ",", "40"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", "40", ",", "3"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ind", "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1.518722", ",", "1", ",", "1.518722", ",", "1"}], 
      "}"}], "}"}]}], ";"}], 
  RowBox[{"(*", "BK7", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"stoprad", "=", "6"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"nstop", "=", "2"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dis", "=", "20"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dobject", "=", 
   RowBox[{"-", "Infinity"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"hobject", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"angle", "=", "2"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", "0.54607", "}"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "angle", ",", 
   "waves"}], "]"}]], "Input"],

Cell["\<\
Two lenses with the aperture stop inside and object at finite distance\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rad", "=", 
   RowBox[{"{", 
    RowBox[{"60", ",", 
     RowBox[{"-", "60"}], ",", 
     RowBox[{"-", "40"}], ",", "40"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", "40", ",", "3"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ind", "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1.518722", ",", "1", ",", "1.518722", ",", "1"}], 
      "}"}], "}"}]}], ";"}], 
  RowBox[{"(*", "BK7", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"stoprad", "=", "6"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"nstop", "=", "2"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dis", "=", "20"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dobject", "=", 
   RowBox[{"-", "200"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"hobject", "=", "8"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"angle", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", "0.54607", "}"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "angle", ",", 
   "waves"}], "]"}]], "Input"],

Cell["\<\
Two lenses with the aperture stop inside and object at finite distance\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rad", "=", 
   RowBox[{"{", 
    RowBox[{"40", ",", 
     RowBox[{"-", "60"}], ",", "60", ",", 
     RowBox[{"-", "40"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", "25", ",", "3"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ind", "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1.518722", ",", "1", ",", "1.518722", ",", "1"}], 
      "}"}], "}"}]}], ";"}], 
  RowBox[{"(*", "BK7", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"stoprad", "=", "6"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"nstop", "=", "2"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dis", "=", "15"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dobject", "=", 
   RowBox[{"-", "300"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"hobject", "=", "8"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"angle", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", "0.54607", "}"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "angle", ",", 
   "waves"}], "]"}]], "Input"],

Cell["Spherical mirror ", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rad", "=", 
   RowBox[{"{", "R", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", "0", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}]}], "}"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", "0", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"stoprad", "=", "r"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nstop", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dis", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dobject", "=", 
   RowBox[{"-", "Infinity"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hobject", "=", "x"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"angle", "=", "\[Alpha]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", "\[Lambda]", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"option", "=", "1"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "angle", ",", 
   "waves"}], "]"}]], "Input"],

Cell["Spherical mirror (numeric)", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rad", "=", 
   RowBox[{"{", 
    RowBox[{"-", "800"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", "0", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}]}], "}"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", "0", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"stoprad", "=", "100"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nstop", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dis", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dobject", "=", 
   RowBox[{"-", "Infinity"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hobject", "=", "x"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"angle", "=", "0.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", "\[Lambda]", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"option", "=", "1"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "angle", ",", 
   "waves"}], "]"}]], "Input"],

Cell["Newton telescope", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rad", "=", 
   RowBox[{"{", "R", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", "0", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}]}], "}"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", 
    RowBox[{"-", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"stoprad", "=", "r"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nstop", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dis", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dobject", "=", 
   RowBox[{"-", "Infinity"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hobject", "=", "x"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"angle", "=", "\[Theta]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", "\[Lambda]", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"option1", "=", "1"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "angle", ",", 
   "waves"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"r", " ", 
     SuperscriptBox["\[Pi]", "2"], " ", 
     SuperscriptBox["\[Theta]", "2"]}], "64800"], 
   FractionBox[
    RowBox[{"360", " ", "R"}], 
    RowBox[{
     SuperscriptBox["r", "2"], " ", "\[Pi]", " ", "\[Theta]"}]]}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"\[Pi]", " ", "R", " ", "\[Theta]"}], 
   RowBox[{"180", " ", "r"}]], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"R", "\[Rule]", "1200"}], ",", 
    RowBox[{"r", "\[Rule]", "100"}], ",", 
    RowBox[{"\[Pi]", "\[Rule]", "3.14"}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"\[Pi]", " ", 
    SuperscriptBox["r", "2"], " ", "\[Theta]"}], 
   RowBox[{"360", " ", "R"}]], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"R", "\[Rule]", "1200"}], ",", 
    RowBox[{"r", "\[Rule]", "100"}], ",", 
    RowBox[{"\[Pi]", "\[Rule]", "3.14"}]}], "}"}]}]], "Input"],

Cell[BoxData["GOSphericalCoefficient"], "Input"],

Cell[BoxData["GOComaCoefficient"], "Input"],

Cell[BoxData["GOAstigmatismCoefficient"], "Input"],

Cell["Newton telescope (numeric)", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rad", "=", 
   RowBox[{"{", 
    RowBox[{"-", "1000"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", "0", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}]}], "}"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", 
    RowBox[{"-", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"stoprad", "=", "100"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nstop", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dis", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dobject", "=", 
   RowBox[{"-", "Infinity"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hobject", "=", "x"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"angle", "=", "1."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", "\[Lambda]1", "}"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "angle", ",", 
   "waves"}], "]"}]], "Input"],

Cell["Cassegrain", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Gamma]", "=", 
   FractionBox[
    RowBox[{"2", "M", 
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Alpha]"}], ")"}]}], 
    RowBox[{"1", "-", 
     SuperscriptBox["M", "2"]}]]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Beta]", "=", 
   FractionBox[
    RowBox[{"M", "-", "\[Alpha]"}], 
    RowBox[{"M", "+", "1"}]]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"rad", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], "f1"}], ",", 
     RowBox[{"\[Gamma]", " ", "f1"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "\[Beta]"}], " ", "f1"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}], ",", "1"}], "}"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", 
    RowBox[{"K1", ",", "K2"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"stoprad", "=", "r"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nstop", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dis", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dobject", "=", 
   RowBox[{"-", "Infinity"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hobject", "=", "x"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"angle", "=", "\[Theta]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", "\[Lambda]", "}"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "\[Theta]", ",", 
   "waves", ",", " ", 
   RowBox[{"OutputLevel", "\[Rule]", "\"\<Coefficients\>\""}]}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"GOSphericalCoefficient", "/.", 
       RowBox[{"K2", "\[Rule]", "0"}]}], ")"}], "\[Equal]", "0"}], ",", 
    "K1"}], "]"}], "//", "Simplify", "  ", 
  RowBox[{"(*", 
   RowBox[{"Dall", "-", "Kirkham"}], " ", "*)"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"GOSphericalCoefficient", "/.", 
       RowBox[{"K1", "\[Rule]", "0"}]}], ")"}], "\[Equal]", "0"}], ",", 
    "K2"}], "]"}], "//", "Simplify", "  ", 
  RowBox[{"(*", 
   RowBox[{"Pressman", "-", "Camichel"}], " ", "*)"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"GOSphericalCoefficient", "/.", 
       RowBox[{"K1", "\[Rule]", 
        RowBox[{"-", "1"}]}]}], ")"}], "\[Equal]", "0"}], ",", "K2"}], "]"}], 
  "//", "Simplify", "  ", 
  RowBox[{"(*", "Cassegrain", " ", "*)"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"GOSphericalCoefficient", "\[Equal]", "0"}], ",", 
      RowBox[{"GOComaCoefficient", "\[Equal]", "0"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"K1", ",", "K2"}], "}"}]}], "]"}], "//", "Simplify"}]], "Input"],

Cell["Cassegrain (numeric)", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rad", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1200"}], ",", 
     RowBox[{"-", "527.473"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", 
    RowBox[{"-", "415.385"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}], ",", "1"}], "}"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.08"}], ",", 
     RowBox[{"-", "4.207"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"stoprad", "=", "100"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nstop", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dis", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dobject", "=", 
   RowBox[{"-", 
    RowBox[{"10.", "^", "10"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hobject", "=", 
   RowBox[{"0.31", "*", 
    FractionBox["\[Pi]", "180"], "*", 
    RowBox[{"10", "^", "10"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"angle", "=", "0.31"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", "\[Lambda]", "}"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "angle", ",", 
   "waves"}], "]"}]], "Input"],

Cell["\<\
A single conic mirror with the aperture stop at a distance -\[Delta] f \
(symbolic)\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "\[Delta]", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rad", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], "f"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", "0", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}]}], "}"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", "K", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"stoprad", "=", "r"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nstop", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dis", "=", 
   RowBox[{
    RowBox[{"-", "\[Delta]"}], " ", "f"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dobject", "=", 
   RowBox[{"-", "Infinity"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hobject", "=", "x"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"angle", "=", "\[Theta]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", "\[Lambda]", "}"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "angle", ",", 
   "waves", ",", " ", 
   RowBox[{"OutputLevel", "\[Rule]", "\"\<Coefficients\>\""}]}], 
  "]"}]], "Input"],

Cell["Schmidt corrector (symbolic)", "Text"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"rad", "=", 
     RowBox[{"{", 
      RowBox[{"Infinity", ",", "Infinity"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"thick", "=", 
     RowBox[{"{", "0", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ind", "=", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"1", ",", "GON", ",", "1"}], "}"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"costasf", "=", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"a4", ",", "asf"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"stoprad", "=", "r"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nstop", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dis", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dobject", "=", 
     RowBox[{"-", "Infinity"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hobject", "=", "x"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"angle", "=", "\[Theta]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"waves", "=", 
     RowBox[{"{", "\[Lambda]", "}"}]}], ";"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "angle", ",", 
   "waves", ",", 
   RowBox[{"OutputLevel", "\[Rule]", "\"\<Coefficients\>\""}]}], 
  "]"}]], "Input"],

Cell["Schmidt corrector (with a curvature at the origin)", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rad", "=", 
   RowBox[{"{", 
    RowBox[{"Infinity", ",", "Rc"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", "0", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "GON", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "Nb", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "Nr", ",", "1"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"a4", ",", "asf"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"stoprad", "=", "r"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nstop", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dis", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dobject", "=", 
   RowBox[{"-", "Infinity"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hobject", "=", "x"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", 
    RowBox[{"\[Lambda]1", ",", "\[Lambda]2", ",", "\[Lambda]3"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"angle", "=", "\[Theta]"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "angle", ",", 
   "waves", ",", 
   RowBox[{"OutputLevel", "\[Rule]", "\"\<Coefficients\>\""}]}], 
  "]"}]], "Input"],

Cell["Schmidt camera", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rad", "=", 
   RowBox[{"{", 
    RowBox[{"Infinity", ",", "Rc", ",", 
     RowBox[{
      RowBox[{"-", "2"}], "f"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"2", "f"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "GON", ",", "1", ",", 
      RowBox[{"-", "1"}]}], "}"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"a4", ",", "asf"}], "}"}], ",", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"stoprad", "=", "r"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nstop", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dis", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dobject", "=", 
   RowBox[{"-", "Infinity"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hobject", "=", "x"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"angle", "=", "\[Theta]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", "\[Lambda]1", "}"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "angle", ",", 
   "waves", ",", 
   RowBox[{"OutputLevel", "\[Rule]", "\"\<Coefficients\>\""}]}], 
  "]"}]], "Input"],

Cell["Wright Camera", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rad", "=", 
   RowBox[{"{", 
    RowBox[{"Infinity", ",", "Infinity", ",", 
     RowBox[{
      RowBox[{"-", "2"}], "f"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"\[Delta]", " ", "f"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "GON", ",", "1", ",", 
      RowBox[{"-", "1"}]}], "}"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"a4", ",", "asf"}], "}"}], ",", "K"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"stoprad", "=", "r"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nstop", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dis", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dobject", "=", 
   RowBox[{"-", "Infinity"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hobject", "=", "x"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", "\[Lambda]", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"angle", "=", "\[Theta]"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "angle", ",", 
   "waves", ",", 
   RowBox[{"OutputLevel", "\[Rule]", "\"\<Coefficients\>\""}]}], 
  "]"}]], "Input"],

Cell["Schmidt camera (numeric)", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rad", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"10", "^", "9"}], ",", 
     RowBox[{"-", "119000"}], ",", 
     RowBox[{"-", "1200"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", 
    RowBox[{"5", ",", "1200"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1.518722", ",", "1", ",", 
      RowBox[{"-", "1"}]}], "}"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2.804", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "10"}]]}], ",", "asf"}], "}"}], ",", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"stoprad", "=", "100"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nstop", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dis", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dobject", "=", 
   RowBox[{"-", "Infinity"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hobject", "=", "x"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"angle", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", "\[Lambda]1", "}"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "angle", ",", 
   "waves"}], "]"}]], "Input"],

Cell["Wright Camera (numeric)", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rad", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"10", "^", "9"}], ",", 
     RowBox[{"-", "73640"}], ",", 
     RowBox[{"-", "1200"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "750"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1.518722", ",", "1", ",", 
      RowBox[{"-", "1"}]}], "}"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"4.5268", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "10"}]]}], ",", "asf"}], "}"}], ",", "0.5966"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"stoprad", "=", "100"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nstop", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dis", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dobject", "=", 
   RowBox[{"-", "Infinity"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hobject", "=", "x"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", "0.54", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"angle", "=", "1.5"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "angle", ",", 
   "waves"}], "]"}]], "Input"],

Cell["Houghton corrector", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rad", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "c1"}], ",", 
     RowBox[{"1", "/", "c2"}], ",", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "c1"}], ",", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "c2"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "GON", ",", "1", ",", "GON", ",", "1"}], "}"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"stoprad", "=", "r"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nstop", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dis", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dobject", "=", 
   RowBox[{"-", "Infinity"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hobject", "=", "x"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"angle", "=", "\[Theta]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", "\[Lambda]", "}"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "angle", ",", 
   "waves", ",", 
   RowBox[{"OutputLevel", "\[Rule]", "\"\<Coefficients\>\""}]}], 
  "]"}]], "Input"],

Cell["Houghton camera", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rad", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "c1"}], ",", 
     RowBox[{"1", "/", "c2"}], ",", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "c1"}], ",", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "c2"}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], "f"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     RowBox[{"\[Delta]", " ", "f"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "GON", ",", "1", ",", "GON", ",", "1", ",", 
      RowBox[{"-", "1"}]}], "}"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"stoprad", "=", "r"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nstop", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dis", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dobject", "=", 
   RowBox[{"-", "Infinity"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hobject", "=", "x"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"angle", "=", "\[Theta]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", "\[Lambda]", "}"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "angle", ",", 
   "waves", ",", 
   RowBox[{"OutputLevel", "\[Rule]", "\"\<Coefficients\>\""}]}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"GOComaCoefficient", "/.", 
   RowBox[{"\[Delta]", "\[Rule]", "2"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"GOSphericalCoefficient", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Delta]", "\[Rule]", "2"}], ",", 
     RowBox[{"c1", "\[Rule]", "c2"}]}], "}"}]}], "]"}]], "Input"],

Cell["Houghton camera (numeric)", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rad", "=", 
   RowBox[{"{", 
    RowBox[{"3518", ",", 
     RowBox[{"-", "2145"}], ",", 
     RowBox[{"-", "1087"}], ",", 
     RowBox[{"-", "5899"}], ",", 
     RowBox[{"-", "1600"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", 
    RowBox[{"15", ",", "3", ",", "8", ",", "1000"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1.518722", ",", "1", ",", "1.518722", ",", "1", ",", 
      RowBox[{"-", "1"}]}], "}"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"stoprad", "=", "100"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nstop", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dis", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dobject", "=", 
   RowBox[{"-", "Infinity"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hobject", "=", "x"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"angle", "=", "1.4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", "\[Lambda]", "}"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "angle", ",", 
   "waves"}], "]"}]], "Input"],

Cell["Maksutov corrector", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rad", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "c1"}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", "c1"}], ")"}], "+", "\[Sigma]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", "\[CapitalDelta]", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "GON", ",", "1"}], "}"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"stoprad", "=", "r"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nstop", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dis", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dobject", "=", 
   RowBox[{"-", "Infinity"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hobject", "=", "x"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", "\[Lambda]", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"angle", "=", "\[Theta]"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "angle", ",", 
   "waves", ",", 
   RowBox[{"OutputLevel", "\[Rule]", "\"\<Coefficients\>\""}]}], 
  "]"}]], "Input"],

Cell["Maksutov camera", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rad", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "c1"}], ",", 
     RowBox[{"1", "/", "c2"}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], "f"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", 
    RowBox[{"\[CapitalDelta]", ",", 
     RowBox[{"\[Delta]", " ", "f"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "GON", ",", "1", ",", 
      RowBox[{"-", "1"}]}], "}"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"stoprad", " ", "=", " ", "r"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nstop", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dis", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dobject", "=", 
   RowBox[{"-", "Infinity"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hobject", "=", "x"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", "\[Lambda]", "}"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "angle", ",", 
   "waves", ",", 
   RowBox[{"OutputLevel", "\[Rule]", "\"\<Coefficients\>\""}]}], 
  "]"}]], "Input"],

Cell["Doublet", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rad", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "c1"}], ",", 
     RowBox[{"1", "/", "c2"}], ",", 
     RowBox[{"1", "/", "c3"}], ",", 
     RowBox[{"1", "/", "c4"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "N1", ",", "1", ",", "N2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "N1b", ",", "1", ",", "N2b", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "N1r", ",", "1", ",", "N2r", ",", "1"}], "}"}]}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"stoprad", "=", "r"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nstop", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dis", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dobject", "=", 
   RowBox[{"-", "Infinity"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hobject", "=", "x"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"angle", " ", "=", "\[Theta]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", 
    RowBox[{"\[Lambda]1", ",", "\[Lambda]2", ",", "\[Lambda]3"}], "}"}]}], 
  ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "angle", ",", 
   "waves", ",", 
   RowBox[{"OutputLevel", "\[Rule]", "\"\<Coefficients\>\""}]}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"eq1", "=", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"GOfocalLength", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], "\[Equal]", 
   RowBox[{"1", "/", "f"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"eq2", "=", 
  RowBox[{
   RowBox[{"Numerator", "[", 
    RowBox[{"Together", "[", 
     RowBox[{
      RowBox[{"GOdistancegauss", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "GOn"}], "]"}], "]"}], "-", 
      RowBox[{"GOdistancegauss", "[", 
       RowBox[{"[", 
        RowBox[{"3", ",", "GOn"}], "]"}], "]"}]}], "]"}], "]"}], "\[Equal]", 
   "0"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"s1", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"eq1", ",", "eq2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b1", ",", "b2"}], "}"}]}], "]"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"GOSphericalCoefficient", "/.", "s1"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"GOComaCoefficient", "/.", "s1"}], "]"}]], "Input"],

Cell["Unit Magnifier", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rad", "=", 
   RowBox[{"{", 
    RowBox[{"15.9", ",", "30.2", ",", "18.5", ",", "12", ",", 
     RowBox[{"-", "12"}], ",", 
     RowBox[{"-", "18.5"}], ",", 
     RowBox[{"-", "30.2"}], ",", 
     RowBox[{"-", "15.9"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", 
    RowBox[{
    "4", ",", "0.5", ",", "1", ",", "15.2", ",", "1", ",", "0.5", ",", "4"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ind", "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "1.609942", ",", "1", ",", "1.624088", ",", "1", ",", 
       "1.624088", ",", "1", ",", "1.609942", ",", "1"}], "}"}], "}"}]}], 
   ";"}], " ", 
  RowBox[{"(*", 
   RowBox[{"SK2", ",", "F2", ",", " ", "F2", ",", "SK2"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"stoprad", "=", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nstop", "=", "4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dis", "=", "7.6"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dobject", "=", 
   RowBox[{"-", "212.199"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hobject", "=", "30"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"angle", "=", "x"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", "\[Lambda]1", "}"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "angle", ",", 
   "waves"}], "]"}]], "Input"]
}, Open  ]]
},
WindowSize->{1920, 992},
WindowMargins->{{-8, Automatic}, {Automatic, -8}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> True}},
TrackCellChangeTimes->False,
FrontEndVersion->"11.0 for Microsoft Windows (64-bit) (July 28, 2016)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "GeometricOptics.nb"]]}, Visible -> False, 
  FrontEndVersion -> "11.0 for Microsoft Windows (64-bit) (July 28, 2016)", 
  StyleDefinitions -> "PrivateStylesheetFormatting.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 34, 0, 71, "Title"],
Cell[616, 24, 136, 3, 46, "Text"],
Cell[755, 29, 3193, 83, 551, "Text"],
Cell[3951, 114, 2296, 56, 473, "Text"],
Cell[6250, 172, 3465, 89, 849, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9752, 266, 42, 0, 71, "Title"],
Cell[9797, 268, 471, 8, 94, "Text"],
Cell[10271, 278, 88, 2, 46, "Text"],
Cell[10362, 282, 885, 32, 253, "Input"],
Cell[11250, 316, 375, 7, 32, "Input"],
Cell[11628, 325, 49, 0, 46, "Text"],
Cell[CellGroupData[{
Cell[11702, 329, 374, 7, 32, "Input"],
Cell[12079, 338, 1869, 49, 50, "Output"]
}, Open  ]],
Cell[13963, 390, 42, 0, 46, "Text"],
Cell[14008, 392, 374, 7, 32, "Input"],
Cell[14385, 401, 6363, 171, 625, "Text"],
Cell[20751, 574, 190, 4, 46, "Text"],
Cell[CellGroupData[{
Cell[20966, 582, 267, 7, 32, "Input"],
Cell[21236, 591, 178, 4, 30, "Output"]
}, Open  ]],
Cell[21429, 598, 66, 0, 46, "Text"],
Cell[21498, 600, 885, 32, 253, "Input"],
Cell[22386, 634, 239, 5, 32, "Input"],
Cell[22628, 641, 6363, 171, 625, "Text"],
Cell[28994, 814, 67, 0, 46, "Text"],
Cell[29064, 816, 1107, 41, 253, "Input"],
Cell[30174, 859, 239, 5, 32, "Input"],
Cell[30416, 866, 46, 0, 46, "Text"],
Cell[30465, 868, 267, 7, 32, "Input"],
Cell[30735, 877, 65, 0, 46, "Text"],
Cell[30803, 879, 844, 31, 231, "Input"],
Cell[31650, 912, 239, 5, 32, "Input"],
Cell[31892, 919, 74, 0, 46, "Text"],
Cell[31969, 921, 957, 32, 275, "Input"],
Cell[32929, 955, 239, 5, 32, "Input"],
Cell[33171, 962, 73, 0, 46, "Text"],
Cell[33247, 964, 913, 34, 231, "Input"],
Cell[34163, 1000, 239, 5, 32, "Input"],
Cell[34405, 1007, 72, 0, 46, "Text"],
Cell[34480, 1009, 968, 35, 253, "Input"],
Cell[35451, 1046, 239, 5, 32, "Input"],
Cell[35693, 1053, 86, 2, 46, "Text"],
Cell[35782, 1057, 982, 36, 253, "Input"],
Cell[36767, 1095, 239, 5, 32, "Input"],
Cell[37009, 1102, 86, 2, 46, "Text"],
Cell[37098, 1106, 982, 36, 253, "Input"],
Cell[38083, 1144, 239, 5, 32, "Input"],
Cell[38325, 1151, 87, 2, 46, "Text"],
Cell[38415, 1155, 980, 35, 253, "Input"],
Cell[39398, 1192, 239, 5, 32, "Input"],
Cell[39640, 1199, 87, 2, 46, "Text"],
Cell[39730, 1203, 1135, 39, 253, "Input"],
Cell[40868, 1244, 239, 5, 32, "Input"],
Cell[41110, 1251, 87, 2, 46, "Text"],
Cell[41200, 1255, 1101, 38, 253, "Input"],
Cell[42304, 1295, 239, 5, 32, "Input"],
Cell[42546, 1302, 94, 2, 46, "Text"],
Cell[42643, 1306, 1096, 38, 253, "Input"],
Cell[43742, 1346, 239, 5, 32, "Input"],
Cell[43984, 1353, 94, 2, 46, "Text"],
Cell[44081, 1357, 1096, 38, 253, "Input"],
Cell[45180, 1397, 239, 5, 32, "Input"],
Cell[45422, 1404, 33, 0, 46, "Text"],
Cell[45458, 1406, 1102, 33, 275, "Input"],
Cell[46563, 1441, 239, 5, 32, "Input"],
Cell[46805, 1448, 42, 0, 46, "Text"],
Cell[46850, 1450, 1121, 34, 275, "Input"],
Cell[47974, 1486, 239, 5, 32, "Input"],
Cell[48216, 1493, 32, 0, 46, "Text"],
Cell[48251, 1495, 1123, 34, 275, "Input"],
Cell[49377, 1531, 239, 5, 32, "Input"],
Cell[49619, 1538, 330, 11, 54, "Input"],
Cell[49952, 1551, 304, 9, 50, "Input"],
Cell[50259, 1562, 330, 10, 53, "Input"],
Cell[50592, 1574, 48, 0, 32, "Input"],
Cell[50643, 1576, 43, 0, 32, "Input"],
Cell[50689, 1578, 50, 0, 32, "Input"],
Cell[50742, 1580, 42, 0, 46, "Text"],
Cell[50787, 1582, 1069, 33, 253, "Input"],
Cell[51859, 1617, 239, 5, 32, "Input"],
Cell[52101, 1624, 26, 0, 46, "Text"],
Cell[52130, 1626, 1581, 53, 333, "Input"],
Cell[53714, 1681, 319, 7, 32, "Input"],
Cell[54036, 1690, 335, 10, 32, "Input"],
Cell[54374, 1702, 340, 10, 32, "Input"],
Cell[54717, 1714, 333, 10, 32, "Input"],
Cell[55053, 1726, 322, 9, 32, "Input"],
Cell[55378, 1737, 36, 0, 46, "Text"],
Cell[55417, 1739, 1330, 43, 267, "Input"],
Cell[56750, 1784, 239, 5, 32, "Input"],
Cell[56992, 1791, 107, 3, 46, "Text"],
Cell[57102, 1796, 1205, 37, 275, "Input"],
Cell[58310, 1835, 316, 7, 32, "Input"],
Cell[58629, 1844, 44, 0, 46, "Text"],
Cell[58676, 1846, 1265, 39, 275, "Input"],
Cell[59944, 1887, 311, 7, 32, "Input"],
Cell[60258, 1896, 66, 0, 46, "Text"],
Cell[60327, 1898, 1361, 43, 253, "Input"],
Cell[61691, 1943, 311, 7, 32, "Input"],
Cell[62005, 1952, 30, 0, 46, "Text"],
Cell[62038, 1954, 1278, 40, 253, "Input"],
Cell[63319, 1996, 311, 7, 32, "Input"],
Cell[63633, 2005, 29, 0, 46, "Text"],
Cell[63665, 2007, 1295, 40, 253, "Input"],
Cell[64963, 2049, 311, 7, 32, "Input"],
Cell[65277, 2058, 40, 0, 46, "Text"],
Cell[65320, 2060, 1374, 43, 255, "Input"],
Cell[66697, 2105, 239, 5, 32, "Input"],
Cell[66939, 2112, 39, 0, 46, "Text"],
Cell[66981, 2114, 1376, 43, 255, "Input"],
Cell[68360, 2159, 239, 5, 32, "Input"],
Cell[68602, 2166, 34, 0, 46, "Text"],
Cell[68639, 2168, 1311, 41, 253, "Input"],
Cell[69953, 2211, 311, 7, 32, "Input"],
Cell[70267, 2220, 31, 0, 46, "Text"],
Cell[70301, 2222, 1459, 44, 253, "Input"],
Cell[71763, 2268, 311, 7, 32, "Input"],
Cell[72077, 2277, 138, 3, 32, "Input"],
Cell[72218, 2282, 228, 6, 32, "Input"],
Cell[72449, 2290, 41, 0, 46, "Text"],
Cell[72493, 2292, 1344, 40, 253, "Input"],
Cell[73840, 2334, 239, 5, 32, "Input"],
Cell[74082, 2341, 34, 0, 46, "Text"],
Cell[74119, 2343, 1205, 38, 253, "Input"],
Cell[75327, 2383, 311, 7, 32, "Input"],
Cell[75641, 2392, 31, 0, 46, "Text"],
Cell[75675, 2394, 1221, 37, 231, "Input"],
Cell[76899, 2433, 311, 7, 32, "Input"],
Cell[77213, 2442, 23, 0, 46, "Text"],
Cell[77239, 2444, 1566, 47, 253, "Input"],
Cell[78808, 2493, 311, 7, 32, "Input"],
Cell[79122, 2502, 197, 6, 32, "Input"],
Cell[79322, 2510, 395, 12, 32, "Input"],
Cell[79720, 2524, 255, 8, 32, "Input"],
Cell[79978, 2534, 107, 2, 32, "Input"],
Cell[80088, 2538, 102, 2, 32, "Input"],
Cell[80193, 2542, 30, 0, 46, "Text"],
Cell[80226, 2544, 1613, 48, 253, "Input"],
Cell[81842, 2594, 239, 5, 32, "Input"]
}, Open  ]]
}
]
*)

